#pragma rtGlobals=1		// Use modern global access method.
Menu "Plot&Fit"
		"ALV DLS Panel",ALVManipulationPnl()
End


Function IR2_ContrProc_F_Hook_Proc()//always run with Jan selection tool.
 	string list= winname(0,64)
 	if(stringmatch(list,"ALVGraph"))
	 	SVAR FolderName=root:Packages:ALVTool:DataFolderName
		SVAR RWaveName=root:Packages:ALVTool:IntensityWaveName
		NVAR ALVorder=root:Packages:ALVTool:ALVorder
		setdatafolder Foldername
		wave Rwv=$Rwavename
		string thenote=note(Rwv)
		ALV_GetSavedParameters()
		ALV_PlotSaved()
		variable cursorB =numberbykey("CursorB", thenote,"=")
		IF (cursorB==0)
			ALVorder=3
			abort
		endif
		
		ALV_Cumulants()	
	endif
end

FUnction ALV_ParameterTable()
		string folderlist,EnclosingFolder,startfolder
		folderlist = IN2G_FindFolderWithWaveTypes("root:", 5, "alv", 1)
		Prompt EnclosingFolder, "Select data folder for sample", popup, folderlist
		doprompt "Plot Input Panel", EnclosingFolder
		//print EnclosingFolder
		if( stringmatch (EnclosingFolder,""))
			abort
		endif
		
		SetDataFolder EnclosingFolder
		DoWindow /K ALVparameters
		DoWindow /K GammaVSqsq
		NewNotebook/k=1/F=1/N=ALVparameters as "ALVParameters"
		notebook ALVparameters margins={0,1,10000}
		string cols="File\tName\tMemo0\tDate\tT[k]\teta[cp]\tn\tTheta\tLambda[nm]\t"
		cols+="q[cm^-1]\tGamma\tD[m^2/s]\tRh[nm]\tWidth\tSkewness"
		notebook ALVparameters, text=cols
		Newdatafolder/o/s summary
		killwaves/z qvector,gamm,rh,Width
				NVAR Levels=root:Packages:ALVTool:ALVLevels		
		SVAR summarypath =root:Packages:ALVTool:summarypath
		summarypath=EnclosingFolder+"Summary:"	
		killwaves/z qvecto9r, gamm,width
		string text ="ALV_tableparams()"
		ScanAllFolders(Enclosingfolder, Levels,"ALV_tableparams()")
		wave qvect,qsq
		
		if (waveexists (qvect))
			duplicate/o qvect, qsq
		else
			doalert 0, "No data found \r Change start folderor number of levels"
			abort
		endif
		qsq=qvect^2
		display/k=1/N=GammaVSqsq g vs qvect
		ModifyGraph mode=3
		Label left "Gamma (1/ms)";DelayUpdate
		Label bottom "q^2"
		//SetAxis left, 0;DelayUpdate
		SetAxis bottom 0,*
		NVAR SaveTable=root:Packages:ALVTool:SaveTable
		If(SaveTable)
			SaveNotebook/M="Save ALVparameters notebook" /I/s=6 ALVparameters as "ALVparameters"
		Endif
		text =enclosingfolder+"basename"
		KillStrings /Z basename,$text
		end

function/s ALV_tableparams()
	SVAR summarypath =root:Packages:ALVTool:summarypath
	string DF=getdatafolder(1)
	string DFname=getdatafolder(0)
	DFname= ReplaceString("'",  DFname, "")
		string rwavename="r"+DFname[1,inf]
		if(WaveExists($rwavename))		
			string thestring=note($rwavename)
			string params="\r"
			params+=rwavename
			params+="\t"+(StringByKey("Samplename",  thestring, "="))
			params+="\t"+(StringByKey("SampMemo(0)",  thestring, "="))
			params+="\t"+(StringByKey("Date",  thestring, "="))
			params+="\t"+(StringByKey("Temperature [K]",  thestring, "="))
			params+="\t"+(StringByKey("Viscosity [cp]",  thestring, "="))
			params+="\t"+(StringByKey("Refractive Index",  thestring, "="))
			params+="\t"+(StringByKey("Angle",  thestring, "="))
			params+="\t"+(StringByKey("Wavelength [nm]",  thestring, "="))
			params+="\t"+(StringByKey("Qvector",  thestring, "="))
			params+="\t"+(StringByKey("Gamma",  thestring, "="))
			params+="\t"+(StringByKey("D",  thestring, "="))
			params+="\t"+(StringByKey("Rh",  thestring, "="))	
			params+="\t"+(StringByKey("Width",  thestring, "="))
			params+="\t"+(StringByKey("Skewness",  thestring, "="))
			notebook ALVparameters,text=params			
			variable order =NumberByKey("CumulantOrder", thestring, "=" )
			If (Order!=0)
				setdatafolder $summarypath
				make/o/n=1 tempw
				tempw[0]=(NumberByKey("Qvector",  thestring, "="))		
				ConcatenateWaves("qvect", "tempw")	
				tempw[0]=(NumberByKey("Gamma",  thestring, "="))	
				ConcatenateWaves("g", "tempw")	
				tempw[0]=(NumberByKey("Rh",  thestring, "="))		
				ConcatenateWaves("Rh", "tempw")
				tempw[0]=(NumberByKey("Width",  thestring, "="))		
				ConcatenateWaves("Width", "tempw")
				Killwaves/z tempw
				setdatafolder DF			
			endif	
			If (exists("basename")==0)
			string/g basename=DFname[1,inf]
		else
			SVAR basename
			Basename=DFname[1,inf]
	endif	
		endif
	return "skip"
end

function ALV_Cumulants()//fits g2-1
	SVAR ListOfGraphFormating=root:Packages:GeneralplottingTool:ListOfGraphFormating		
	SVAR FolderName=root:Packages:ALVTool:DataFolderName
	SVAR RWaveName=root:Packages:ALVTool:IntensityWaveName
	SVAR QWaveName=root:Packages:ALVTool:QWavename		
	SVAR SWaveName=root:Packages:ALVTool:ErrorWaveName	
	NVAR Lambda=root:Packages:ALVTool:ALVLambda
	NVAR ALVviscosity=root:Packages:ALVTool:ALVviscosity
	NVAR ALVtheta=root:Packages:ALVTool:ALVtheta
	NVAR ALVn=root:Packages:ALVTool:ALVn
	NVAR ALVRh=root:Packages:ALVTool:ALVRh
	NVAR ALVD=root:Packages:ALVTool:ALVD
	NVAR ALVT=root:Packages:ALVTool:ALVT
	NVAR ALVOrder= root:Packages:ALVTool:ALVOrder
	NVAR ALVgamma=root:Packages:ALVtool:ALVgamma
	NVAR ALVwidth=root:Packages:ALVtool:ALVwidth
	NVAR ALVskewness=root:Packages:ALVtool:ALVskewness
	
	NVAR ALVCursorA=root:Packages:ALVtool:ALVCursorA
	NVAR ALVCursorB=root:Packages:ALVtool:ALVCursorB
	NVAR ALVOrder=root:Packages:ALVtool:ALVorder
	NVAR qvector=root:Packages:ALVtool:ALVqvector
	
	//NVAR graphlogx=root:Packages:ALVTool:graphlogx,graphlogy=root:Packages:ALVTool:graphlogy
	
	if (datafolderexists(foldername))
		setdatafolder foldername
		wave RWave=$Rwavename	
		wave QWave=$Qwavename	
		wave SWave=$Swavename
	endif
	string csra,csrb,tracename
	csra=num2str(pcsr(a  , "ALVgraph"));abortonRTE
	csrb=num2str(pcsr(b  , "ALVgraph"));abortonRTE
	//if (!waveexists(W_coef))
		make/N=3/O W_coef={-.1,-.02,.0001}
	//endif
	duplicate/o Rwave,log_Rwave
		log_Rwave=ln(sqrt(Rwave))//ALV plots g2-1 I think.  I fit g1, which is sqrt(g2-1)	
	If (ALVOrder==2)
		CurveFit/NTHR=1/Q/TBOX=800 LINE,  log_Rwave[pcsr(A),pcsr(B)] /X=qWAVE/W=sWAVE/I=1 /D 	
		ALVwidth=NaN
		ALVskewness=NaN
		wave fit_log_Rwave//line is only 2 points, so does not plot right on linear scale.  This code corrects
		variable left=leftx(fit_log_Rwave)
		variable right=pnt2x(fit_log_Rwave,numpnts(fit_log_Rwave)-1)
		Redimension/S/N=50 fit_log_Rwave
		SetScale/I x left,right,"", fit_log_Rwave
		fit_log_Rwave=w_Coef[0]+w_Coef[1]*x
	elseif  (ALVOrder==5)
		CurveFit/NTHR=1/Q/TBOX=800 poly 5,  log_Rwave[pcsr(A),pcsr(B)] /X=qWAVE/W=sWAVE/I=1 /D 
		ALVwidth=(2*w_Coef[2])^.5/(-w_Coef[1])	//Pusey Biochemistry 13,4171(1774) eq. 20
		ALVskewness=(6*w_Coef[3])/(-w_Coef[1]^3)
	elseif  (ALVOrder==4)
		CurveFit/NTHR=1/Q/TBOX=800 poly 4,  log_Rwave[pcsr(A),pcsr(B)] /X=qWAVE/W=sWAVE/I=1 /D 
		ALVwidth=(2*w_Coef[2])^.5/(-w_Coef[1])
		ALVskewness=(6*w_Coef[3])/(-w_Coef[1]^3)
	else 
		CurveFit/NTHR=1/Q/TBOX=800 poly 3,  log_Rwave[pcsr(A),pcsr(B)] /X=qWAVE/W=sWAVE/I=1 /D 	
		ALVwidth=(2*w_Coef[2])^.5/(-w_Coef[1])
		ALVskewness=NaN	
	endif
		
	if (ALVskewness<0)
		ALVskewness=-abs(ALVskewness)^1/3
	else
		ALVskewness=(ALVskewness)^1/3
	endif
	wave fit_log_Rwave
		
	fit_log_Rwave=(e^fit_log_Rwave)^2//channge to match plot which is g2-1
	killwaves/z log_Rwave,W_ParamConfidenceInterval
	Killvariables/z:S_info
	tracename=findtrace ("fit_log_Rwave")
	if (strsearch (tracename,"fit_log_Rwave",0)==-1)
			APPENDtograph fit_log_Rwave	
	endif
		ModifyGraph mode(fit_log_Rwave)=0,rgb(fit_log_Rwave)=(0,0,0)		
		ModifyGraph rgb(fit_log_Rwave)=(0,0,0)
		qvector= (4*pi*ALVn/Lambda)*sin(ALVtheta*pi/(2*180))//nm-1
		variable temp =(4*pi*ALVn/Lambda)*sin(ALVtheta*pi/(2*180))//nm-1
		qvector*=1e8//cm-1	
		ALVgamma= -W_coef[1]//2.303//(2.303*2)//1/ms
		ALVD=ALVgamma*1e3/qvector^2//cm^2s^-1
		ALVRh=1.38e-18*ALVT*1e7/(6* pi* ALVviscosity*.01*ALVD) //nm	
		ALVD*=1e10//m	
		ALVCursorA=xcsr(a)
		ALVCursorB=xcsr(b)
end


function ALV_PlotSaved()	
	SVAR FolderName=root:Packages:ALVTool:DataFolderName
	SVAR RWaveName=root:Packages:ALVTool:IntensityWaveName
	SVAR QWaveName=root:Packages:ALVTool:QWavename		
	SVAR SWaveName=root:Packages:ALVTool:ErrorWaveName	
	NVAR graphlogx=root:Packages:ALVTool:graphlogx,graphlogy=root:Packages:ALVTool:graphlogy
	NVAR ALVerrors=root:Packages:ALVTool:ALVerrors
	NVAR ALVcursorA =root:Packages:ALVtool:ALVCursorA
	NVAR ALVcursorB =root:Packages:ALVtool:ALVCursorB
	setdatafolder  FolderName	; AbortOnRTE
	Appendtograph $RWaveName vs $qWaveName
		//start=LocateValue(Rwavename, .9,1,2)
		
		Legend/C/N=text1
	 	setaxis/A
			Label Left "\Z16\f01\F'arial'g\B2\M\Z16(\F'Symbol't)-1"
			Label bottom "\Z18\F'Symbol't\F'Arial' (ms)"
			TextBox/K/N=FolderLegend	
		ModifyGraph log(left)=graphlogy
		ModifyGraph log(bottom)=graphlogx
		ModifyGraph tick=2		
			string tracelist=TraceNameList("ALVgraph", ";", 1 )
			variable items=ItemsInList(tracelist )
			
			items=items-1
			string tracename=StringFromList(items, tracelist )
			ModifyGraph mode($tracename)=3,marker($tracename)=8,msize($tracename)=2
			If (ALVerrors)
				ErrorBars $Rwavename Y,wave=($SWaveName,$SWaveName)
			endif
			Cursor A,$Rwavename,  ALVcursorA
			Cursor B, $Rwavename, ALVcursorB
		If (ALVcursorb==0)
			variable N=(LocateValue(Rwavename, 0,3,0))-1//find place where below zero
			If (2==numtype(N))
				N=numpnts(Rwave)
			endif
			Cursor B,$Rwavename,  N
			Cursor A, $Rwavename, 4
		endif
	end
	
function ALV_SaveResults()
	SVAR FolderName=root:Packages:ALVTool:DataFolderName
	setdatafolder Foldername
	SVAR RWaveName=root:Packages:ALVTool:IntensityWaveName	
	NVAR ALVRh=root:Packages:ALVTool:ALVRh
	NVAR ALVD=root:Packages:ALVTool:ALVD
	NVAR ALVOrder= root:Packages:ALVTool:ALVOrder
	NVAR ALVgamma=root:Packages:ALVtool:ALVgamma
	NVAR ALVwidth=root:Packages:ALVtool:ALVwidth
	NVAR ALVskewness=root:Packages:ALVtool:ALVskewness	
	NVAR ALVCursorA=root:Packages:ALVtool:ALVCursorA
	NVAR ALVCursorB=root:Packages:ALVtool:ALVCursorB
	NVAR ALVqvector=root:Packages:ALVtool:ALVqvector
	string thenote=note($rwavename)
	string temp
	sprintf temp, "%.4g", ALVD
	thenote =ReplaceStringByKey("D", thenote, temp,"=" )
	sprintf temp, "%.4g", ALVrh
	thenote =ReplaceStringByKey("Rh", thenote,temp,"=" )
	sprintf temp, "%.4g", ALVgamma
	thenote= ReplaceStringByKey("Gamma", thenote, temp,"=" )
	sprintf temp, "%.4g", ALVwidth
	thenote =ReplaceStringByKey("Width", thenote,temp,"=" )
	sprintf temp, "%.4g", ALVskewness
	thenote =ReplaceStringByKey("Skewness", thenote,  temp,"=" )
	sprintf temp, "%.4g", ALVqvector
	print temp
	thenote =ReplaceStringByKey("qvector", thenote, temp,"=" )
	temp=num2istr(ALVCursorA)
	thenote =ReplaceStringByKey("CursorA", thenote, temp,"=" )
	temp=num2istr(ALVCursorB)
	thenote =ReplaceStringByKey("CursorB", thenote, temp,"=" )
	temp=num2istr(ALVOrder)
	thenote =ReplaceStringByKey("CumulantOrder", thenote, temp,"=" )
	variable pts=strlen(rwavename)
	print pts
	If (pts >=32)
		Doalert 0,"R wavename to long."
	endif
	Note /K $RWaveName
	Note  $RWaveName ,thenote
	wave originalRwave
	if (waveexists(originalRwave))
		Note /K originalRwave ,thenote
	endif
	//SVAR Parameters=thenote
	PRINT thenote
	string DF=getdatafolder(1)
	setdatafolder"::"
	make/T/o/n=8 ALV
	ALV[0]="alvdata"
	ALV[1]="Do not delete"
	ALV[2]="Needed to identify summarized data"
end

function ALV_GetSavedParameters()//loads old fit
	SVAR FolderName=root:Packages:ALVTool:DataFolderName
	SVAR RWaveName=root:Packages:ALVTool:IntensityWaveName
	NVAR ALVtheta=root:Packages:ALVTool:ALVtheta
	NVAR ALVlambda=root:Packages:ALVTool:ALVLambda
	NVAR ALVT= root:Packages:ALVTool:ALVT
	NVAR ALVn=root:Packages:ALVTool:ALVn
	NVAR ALVviscosity=root:Packages:ALVTool:ALVviscosity
	
	NVAR ALVRh=root:Packages:ALVTool:ALVRh
	NVAR ALVD=root:Packages:ALVTool:ALVD
	NVAR ALVT=root:Packages:ALVTool:ALVT
	NVAR ALVOrder= root:Packages:ALVTool:ALVOrder
	NVAR ALVgamma=root:Packages:ALVtool:ALVgamma
	NVAR ALVwidth=root:Packages:ALVtool:ALVwidth
	NVAR ALVskewness=root:Packages:ALVtool:ALVskewness	
	NVAR ALVCursorA=root:Packages:ALVtool:ALVCursorA
	NVAR ALVCursorB=root:Packages:ALVtool:ALVCursorB
	NVAR ALVqvector=root:Packages:ALVtool:ALVqvector
	
	
	setdatafolder FolderName	
	string thenote=note($rwavename)
	ALVT= numberbykey("Temperature [K]", thenote  , "=") 
	ALVviscosity=numberbykey("Viscosity [cp]", thenote  , "=") 
	ALVn=numberbykey("Refractive Index", thenote  , "=")
	ALVlambda= numberbykey("Wavelength [nm]", thenote  , "=")
	ALVtheta= numberbykey("Angle", thenote  , "=")
		
	ALVD =NumberByKey("D", thenote,"=" )
	ALVRh =NumberByKey("Rh", thenote,"=" )
	ALVgamma =NumberByKey("Gamma", thenote,"=" )
	ALVwidth=NumberByKey("Width", thenote,"=" )
	ALVskewness =NumberByKey("Skewness", thenote,"=" )
	ALVqvector =NumberByKey("qvector", thenote,"=" )
	ALVcursorA =NumberByKey("CursorA", thenote,"=" )
	ALVcursorB =NumberByKey("CursorB", thenote,"=" )
	ALVorder =NumberByKey("CumulantOrder", thenote,"=" )
end


function/s ALV_CleanString(thestring)
	string thestring	
	string temp
	thestring= ReplaceString("\t", thestring, "") 
	thestring= ReplaceString("  ", thestring, "") 
	thestring= ReplaceString("\r", thestring, ";") 	
	thestring= ReplaceString(":", thestring, "=") 
	thestring= ReplaceString("\"", thestring, "") 
	thestring= ReplaceString("=", thestring, "=") 
	thestring= ReplaceString(" =", thestring, "=") 
	thestring= ReplaceString(" [°]", thestring, "") 	//characsters in angle	
	thestring= ReplaceString(" []", thestring, "")
	temp=	StringByKey("Time", thestring, "=")//fix time
	temp=ReplaceString("=", temp, "-") 
	thestring=ReplaceStringByKey("Time", thestring, temp ,"=")
	return thestring
end


Function ALVButtonProc(ctrlName) : ButtonControl
	String ctrlName
	SVAR ListOfGraphFormating=root:Packages:GeneralplottingTool:ListOfGraphFormating		
	SVAR FolderName=root:Packages:ALVTool:DataFolderName
	SVAR RWaveName=root:Packages:ALVTool:IntensityWaveName
	SVAR QWaveName=root:Packages:ALVTool:QWavename		
	SVAR SWaveName=root:Packages:ALVTool:ErrorWaveName	
	NVAR ALVLambda=root:Packages:ALVTool:ALVLambda
	NVAR ALVviscosity=root:Packages:ALVTool:ALVviscosity
	NVAR ALVtheta=root:Packages:ALVTool:ALVtheta
	NVAR ALVn=root:Packages:ALVTool:ALVn
	NVAR ALVRh=root:Packages:ALVTool:ALVRh
	NVAR D=root:Packages:ALVTool:ALVD
	NVAR ALVT=root:Packages:ALVTool:ALVT
	NVAR ALVgamma=root:Packages:ALVTool:ALVgamma
	NVAR ALVOrder= root:Packages:ALVTool:ALVOrder
	NVAR ALVwidth=root:Packages:ALVtool:ALVwidth
	NVAR graphlogx=root:Packages:ALVTool:graphlogx,graphlogy=root:Packages:ALVTool:graphlogy
	NVAR ALVerrors=root:Packages:ALVTool:ALVerrors
	variable start,delta,N,items,qvector
	string wavenote, cmd,checked,csra,csrb,fitwavename,tracelist,Nstr,list,tracename
	if (datafolderexists(foldername))
		setdatafolder foldername
		wave RWave=$Rwavename	
		wave QWave=$Qwavename	
		wave SWave=$Swavename
		wave w_coef
	endif
	
	IF(cmpstr(ctrlName,"LoadASC")==0)
			load1d(1,0,4,-1,26,2,".asc",0)//load1d(newfolder,qdisplay,nm,nameline,headerlines,nocols,filetype,dialog)
			SVAR basename
			string swavenm="s"+basename
			string rwavenm="r"+basename
			duplicate/o $rwavenm,$Swavenm
			wave  rwv=$rwavenm
			duplicate/o wave2,  seconds
			duplicate/o wave3, counts	
			killwaves/Z wave2,wave3
			if (waveexists (wave5))
				wave wave5
				duplicate/o wave5,$swavenm
			else//if no errorwave, generate one
				IN2G_GenerateSASErrors($rwavenm,$Swavenm,6,1, 0,0,3)//(IntWave,ErrWave,Pts_avg,Pts_avg_multiplier, IntMultiplier,MultiplySqrt)
			endif			
			String/g Parameters
			String thenote
			SVAR Header
			thenote=ALV_CleanString(header)
			thenote+=";Qvector=0;CumulantOrder=0;Gamma=2;Width=0;Skewness=0;D=0;Rh=0,;CursorA=0;CursorB=0"
			Parameters=thenote	
		ALVT= numberbykey("Temperature [K]", thenote  , "=") 
		ALVviscosity=numberbykey("Viscosity [cp]", thenote  , "=") 
		ALVn=numberbykey("Refractive Index", thenote  , "=")
		ALVlambda= numberbykey("Wavelength [nm]", thenote  , "=")
		ALVtheta= numberbykey("Angle", thenote  , "=")//Angle []  degree notation depends on computer
		If (alvtheta==nan)
			DoAlert 0, "Degree symbol in import file is causing\ra problem reading the angle"
		endif
	
		string temp
		sprintf temp, "%.4g", ALVT
		thenote= ReplaceStringByKey("Temperature [K]", thenote  , temp,"=") 
		sprintf temp, "%.4g", ALVviscosity
		thenote=ReplaceStringByKey("Viscosity [cp]", thenote  , temp,"=") 
		sprintf temp, "%.4g", ALVn
		thenote=ReplaceStringByKey("Refractive Index", thenote  , temp,"=")
		sprintf temp, "%.4g", ALVlambda
		thenote= ReplaceStringByKey("Wavelength [nm]", thenote  , temp,"=")
		sprintf temp, "%.4g", ALVtheta
		thenote= ReplaceStringByKey("Angle", thenote  , temp,"=")
		Note/k $rwavenm ,thenote	
			if(1)	
				killwaves/Z wave4,wave5
				display/k=1 counts vs seconds
				Label left "Counts";DelayUpdate
				Label bottom "Seconds"
				TextBox/C/N=text0 basename
				ModifyGraph tick=2
		endif	
	endif
			
	IF(cmpstr(ctrlName,"Cumulant")==0)
			ALV_cumulants()
	ENDIF
		
	IF(cmpstr(ctrlName,"ALVsave")==0)
			ALV_SaveResults()
	ENDIF	
	
	IF(cmpstr(ctrlName,"ALVTable")==0)
			ALV_ParameterTable()
	ENDIF	

	IF(cmpstr(ctrlName,"Restart")==0)
		Edit/K=1 W_coef;DelayUpdate
		W_coef={-.1,-.02,.0001}
		DoAlert 0, "Try Again or \rChange Coefficients"
	endif

	IF(cmpstr(ctrlName,"RemoveALVTrace")==0)
		tracelist=TraceNameList("ALVgraph", ";", 1 )
		tracename=StringFromList(0, tracelist,";")
		If (!stringmatch(tracename, "" ))
			tracename=StringFromList(1, tracelist,";")
			RemoveFromGraph $tracename
		else
			Legend/K/N=text1
			string boxname="CF_"+Rwavename
			TextBox/K/N=$boxname
		endif	
	endif
	
	IF(cmpstr(ctrlName,"PlotALVData")==0)	
		setdatafolder  FolderName	; AbortOnRTE
		Appendtograph RWave vs qwave
		//start=LocateValue(Rwavename, .9,1,2)
		N=(LocateValue(Rwavename, 0,3,0))-1
		If (2==numtype(N))
			N=numpnts(Rwave)
		endif
		Nstr=num2str(N)
		execute("cursor b,"+possiblyquotename(RWaveName)+","+Nstr)
		execute("cursor a,"+possiblyquotename(RWaveName)+","+"4")
		If (WaveExists(yavedata))
			Removefromgraph yavedata
		endif
		Legend/C/N=text1
	 	setaxis/A
			Label Left "\Z16\f01\F'arial'g\B2\M\Z16(\F'Symbol't)-1"
			Label bottom "\Z18\F'Symbol't\F'Arial' (ms)"
			TextBox/K/N=FolderLegend		
		ModifyGraph log(left)=graphlogy
		ModifyGraph log(bottom)=graphlogx
		ModifyGraph tick=2		
			tracelist=TraceNameList("ALVgraph", ";", 1 )
			items=ItemsInList(tracelist )
			items=items-1
			tracename=StringFromList(items, tracelist )
			ModifyGraph mode($tracename)=3,marker($tracename)=8,msize($tracename)=2
			If (ALVerrors)
				ErrorBars $Rwavename Y,wave=(swave,swave)
			endif

	endif
	
	IF(cmpstr(ctrlName,"ClipALV")==0)
		Wave w = CsrWaveRef(A)
		setdatafolder GetWavesDataFolder(Rwave, 1 )
		 variable Npts=numpnts(Rwave)

		if (!WaveExists(originalrwave))
			duplicate Rwave, originalRwave
			duplicate Qwave, originalQwave
			duplicate Swave, originalSwave
		endif
		DeletePoints pcsr(b)+1,Npts, Rwave,Qwave,Swave
		DeletePoints 0,pcsr(a), Rwave,Qwave,Swave
	 
	 	string text="Data Clipped"
	 	Note/K qwave
	 	Note rwave, text
	 	Note qwave, text	
	 	WaveStats/Q/Z rwave
	 	SetAxis left V_min,v_max
	 	WaveStats/Q/Z qwave
	 	SetAxis bottom V_min,v_max
	 		execute("cursor a,"+possiblyquotename(RWaveName)+","+"0")
	endif
	
	IF(cmpstr(ctrlName,"Restore")==0)
		Wave w = CsrWaveRef(A)
		setdatafolder GetWavesDataFolder(Rwave, 1 )	
		 Duplicate/o originalrwave,$rwavename; AbortOnRTE	
		  Duplicate/o originalqwave,$qwavename		
		   Duplicate/o originalswave,$swavename		
	 	appendtograph/W=ALVGraph Rwave vs qwave
		N=(LocateValue(Rwavename, 0,3,0))-1//find place where below zero
		If (2==numtype(N))
			N=numpnts(Rwave)
		endif
		Nstr=num2str(N)
		execute("cursor b,"+possiblyquotename(RWaveName)+","+Nstr)
		execute("cursor a,"+possiblyquotename(RWaveName)+","+"4")
		//ModifyGraph mode=4
		ModifyGraph log(left)=graphlogy
		ModifyGraph log(bottom)=graphlogx
		Label Left "\Z14\f01\F'arial'g(tau)"
		Label bottom "\\Z14\\f01\\F'Times New Roman'tau(ms)"
		ModifyGraph mode($Rwavename)=3,marker($Rwavename)=8,msize($Rwavename)=2
		If (ALVerrors)
			ErrorBars $Rwavename Y,wave=(swave,swave)
		endif
		SetAxis/A
	endif
end

Function ALVManipulationPnl()
	IN2G_CheckScreenSize("height",670)
	DoWindow DWS_alvManipulationPnl
	if(V_Flag)
		DoWindow/K DWS_ALVManipulationPnl
	endif
	IR1D_InitDataManipulation()
	IR1P_InitializeGenGraph()
	If(!datafolderexists (" root:Packages:ALVTool"))
		Newdatafolder root:Packages:ALVTool
	endif	
	variable/g root:Packages:ALVtool:GraphLogY=1,root:Packages:ALVtool:GraphLogx=1
	variable/g root:Packages:ALVTool:ALVtheta
	variable/g root:Packages:ALVTool:ALVT
	variable/g root:Packages:ALVTool:ALVD=0
	variable/g root:Packages:ALVTool:ALVRh
	variable/g  root:Packages:ALVTool:ALVOrder=2
	variable/g root:Packages:ALVTool:ALVgamma
	variable/g root:Packages:ALVTool:ALVerrors
	variable/g root:Packages:ALVtool:ALVLambda
	variable/g root:Packages:ALVtool:ALVviscosity
	variable/g root:Packages:ALVtool:ALVn
	variable/g root:Packages:ALVtool:ALVwidth=0
	 variable/g root:Packages:ALVtool:ALVskewness=0
	variable/g root:Packages:ALVtool:ALVCursorA=0
	variable/g root:Packages:ALVtool:ALVCursorB=0
	variable/g root:Packages:ALVtool:ALVorder=3
	variable/g root:Packages:ALVtool:ALVqvector
	variable/g root:Packages:ALVTool:USEqrsData=1
	variable/g root:Packages:ALVTool:ALVLevels=2
	variable/g root:Packages:ALVTool:g1=0
	string/g root:Packages:ALVTool:summarypath
	variable/g root:Packages:ALVTool:SaveTable
	make/o/N=2 xavedata,yavedata
	xavedata={ .02, .15}
	yavedata={ 1, .01}
	PlotALVData("yavedata","xavedata", "")
	setAxis bottom .02, .1
	SetAxis/A left
	removefromgraph yavedata
	textBox/K/N=text0
end

Function PlotALVData(rwavename,qwavename, text)
	string rwavename,qwavename, text
	wave rwave=$rwavename
	wave qwave=$qwavename			
	dowindow/K ALVGraph
	Display/K=1/N=ALVGraph/W=(1*IN2G_ScreenWidthHeight("width"),1*IN2G_ScreenWidthHeight("heigth"),30*IN2G_ScreenWidthHeight("width"),60*IN2G_ScreenWidthHeight("height")) rwave vs qwave
	ControlBar /T 210
	TitleBox  title anchor= MT,  fColor=(0,0,65534 ), font="arial", fsize=18, fstyle=0, Title="ALV Tool",Labelback=0, POS={225,1},Size={200,18}
	variable YPOS=3
	CheckBox errors pos={70,YPOS},title="Errors?", variable= root:Packages:ALVTool:ALVerrors
	CheckBox GraphLogx pos={135,YPOS},title="LogX", variable= root:Packages:ALVTool:GraphLogx, proc=DWS_GenPlotCheckBox
	CheckBox GraphLogY pos={180,YPOS},title="LogY", variable= root:Packages:ALVTool:GraphLogY, proc=DWS_GenPlotCheckBox
	//CheckBox g1 pos={225,YPOS},title="g1?", variable= root:Packages:ALVTool:g1
	
	YPOS=130
	Button PlotALVData,pos={0,YPOS},size={40,16},font="Times New Roman",fSize=10,proc=ALVButtonProc,title="Plot"		
	Button ClipALV,pos={42,YPOS},size={40,16},font="Times New Roman",fSize=10,proc=ALVButtonProc,title="Clip"		
	Button Restore,pos={83,YPOS},size={45,16},font="Times New Roman",fSize=10,proc=ALVButtonProc,title="Restore"	
	Button RemoveALVTrace,pos={128,YPOS},size={50,16},font="Times New Roman",fSize=10,proc=ALVButtonProc,title="Remove"		
	Button Cumulant,pos={178,YPOS},size={40,16},font="Times New Roman",fSize=10,proc=ALVButtonProc,title="Cum"	
	Button LoadASC,pos={219,YPOS},size={35,16},font="Times New Roman",fSize=10,proc=ALVButtonProc,title="Load"		
	Button Restart,pos={255,YPOS},size={45,16},font="Times New Roman",fSize=10,proc=ALVButtonProc,title="Restart"	
	SetVariable ALVorder, pos={310,YPOS}, size={55,20},title="ord", value= root:Packages:ALVTool:ALVorder,limits={2,5,1 },proc= ALV_SetVarProc
	YPOS=150
	SetVariable ALVT, pos={2,YPOS}, size={65,20},title="T",format="%.0f K",value= root:Packages:ALVTool:ALVT
	SetVariable ALVn, pos={70,YPOS}, size={59,20},title="n", value= root:Packages:ALVTool:ALVn		
	SetVariable ALVviscosity, pos={130,YPOS}, size={75,20},title="Vis", format="%.2f cp",limits={0,Inf,0.01},value= root:Packages:ALVTool:ALVviscosity,format= "%.3f"
	SetVariable ALVLambda, pos={210,YPOS}, size={75,20}, title="L",value= root:Packages:ALVTool:ALVLambda	,format="%.1f nm"
	SetVariable ALVtheta, value= root:Packages:ALVTool:ALVtheta	,format="%.1f", pos={295,YPOS}, size={60,20},font="Symbol",fSize=12,title="q"
	YPOS=168
	valdisplay ALVDiff, pos={2,YPOS}, size={100,20},title="D",  value= #"root:Packages:ALVTool:ALVD",format="%.2f m^2/sec"//"%.3g" 
	valdisplay ALVR, pos={100,YPOS}, size={60,20},title="R"	,format="%.1f nm", value=#" root:Packages:ALVTool:ALVRh"
	valdisplay ALVgamma, pos={162,YPOS}, size={85,20},fSize=10,title="Gam",format="%.2f 1/ms", value= #"root:Packages:ALVTool:ALVgamma"
	valdisplay ALVwidth, pos={255,YPOS}, size={50,20},font="Symbol",fSize=10,title="dG/G",format="%.2f", value= #"root:Packages:ALVTool:ALVwidth"
	valdisplay ALVskewness, pos={310,YPOS}, size={65,20},title="skew",format="%.2f", value= #"root:Packages:ALVTool:ALVskewness"
	YPOS=188
	Button ALVsave,pos={3,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=ALVButtonProc,title="Save Results"		
	Button ALVTable,pos={70,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=ALVButtonProc,title="Summary"	
	SetVariable ALVLevels, pos={140,YPOS}, size={60,20},title="Levels", value= root:Packages:ALVTool:ALVLevels,limits={2,5,1 }
	CheckBox SaveTable pos={210,YPOS},title="Save Table?", variable= root:Packages:ALVTool:SaveTable

	String PckgDataFolder="ALVTool"
	String PanelWindowName="ALVGraph"
	String AllowedIrenaTypes=""//"DSM_Int;SMR_Int;"
	String AllowedResultsTypes=""//"SizesNumberDistribution;SizesVolumeDistribution;"
	String AllowedUserTypes=""//"*_par;" or "r*;"	
	String UserNameString=""//"_par" or "qrs"
	String XUserTypeLookup=""//"r*:q*;"	
	String EUserTypeLookup=""//"s*;"
	variable RequireErrorWaves=0
	variable  AllowModelData=0	
	IR2C_AddDataControls(PckgDataFolder,PanelWindowName,AllowedIrenaTypes, AllowedResultsTypes, AllowedUserTypes, UserNameString, XUserTypeLookup,EUserTypeLookup, RequireErrorWaves,AllowModelData)	
	MoveSelectionTools(2, 2)
end

Function ALV_SetVarProc(ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName
	Variable varNum
	String varStr
	String varName	
	if (cmpstr("ALVorder",ctrlname)==0)
		ALV_cumulants()
	endif	
end
